#ifndef usb_R6_4H
#define usb_R6_4H
#include <objbase.h>

#define bufferLength 32
#define searchMaxDevice 10
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef struct _HIDD_ATTRIBUTES {
    ULONG Size;
    USHORT VendorID;
    USHORT ProductID;
    USHORT VersionNumber;
} HIDD_ATTRIBUTES, *PHIDD_ATTRIBUTES;
//---------------------------------------------------------
void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
bool (__stdcall *HidD_GetAttributes)(IN HANDLE HidDeviceObject,
                                    OUT PHIDD_ATTRIBUTES Attributes);
//---------------------------------------------------------
interface ISynchronous: public IUnknown {
   public:
     virtual bool __stdcall synchReadUSBReport(HANDLE hidDevObject,
             void *inputReportBuffer, ULONG inputReportBufferLength) = 0;
     virtual  HANDLE __stdcall synchOpenUSBDevice() = 0;
     virtual void __stdcall setUshortVid(USHORT vid) = 0;
};
//---------------------------------------------------------
interface IAsynchronous: public IUnknown {
   public:
     virtual bool __stdcall asynchReadUSBReport(HANDLE hidDevObject,
             void *inputReportBuffer, ULONG inputReportBufferLength)= 0;
     virtual  HANDLE __stdcall asynchOpenUSBDevice() = 0;
     virtual void __stdcall setCharVid(const char* vid) = 0;
};
//---------------------------------------------------------
// deklaracje identyfikatorw GUID
//['{E7D1FDE1-8A61-11D9-8C68-00E07D843852}']
static const GUID iidISynchronous =
    {0xE7D1FDE1, 0x8A61, 0x11D9, {0x8C, 0x68, 0x00, 0xE0,
                                  0x7D, 0x84, 0x38, 0x52}};
//['{E7D1FDE2-8A61-11D9-8C68-00E07D843852}']
static const GUID iidIAsynchronous =
    {0xE7D1FDE2, 0x8A61, 0x11D9, {0x8C, 0x68, 0x00, 0xE0,
                                  0x7D, 0x84, 0x38, 0x52}};
//---------------------------------------------------------
class TUSBDevice: public ISynchronous, public IAsynchronous {
   private:
     LONG Addend; // licznik odwoa do interfejsw klasy TUSBDevice
     string pathUSBDevice;
     DWORD memberIndex;
     HIDD_ATTRIBUTES hiddAttributes;
     PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData;
     DWORD numberOfBytesRead;
     DWORD result;
     GUID classGuid;
     HMODULE hHidLib;
     DWORD deviceInterfaceDetailDataSize;
     HDEVINFO deviceInfoSet;
     SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
     USHORT usVid;
     const char *chVid;
   public:
     TUSBDevice();
     ~TUSBDevice();
     void __stdcall setUshortVid(USHORT vid);
     void __stdcall setCharVid(const char *vid);
     void __stdcall displayError(const char* msg);
     bool __stdcall synchReadUSBReport(HANDLE hidDevObject,
                void *inputReportBuffer, ULONG inputReportBufferLength);
     bool __stdcall asynchReadUSBReport(HANDLE hidDevObject,
                void *inputReportBuffer, ULONG inputReportBufferLength);
     HANDLE __stdcall synchOpenUSBDevice();
     HANDLE __stdcall asynchOpenUSBDevice();
     string __stdcall getUSBDevicePath(UINT);

     virtual HRESULT __stdcall
                  QueryInterface(const IID& iid, void **Obj);
     virtual ULONG __stdcall AddRef();
     virtual ULONG __stdcall Release();
};
//---------------------------------------------------------
#endif

